/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import proguard.ClassPath;
import proguard.ClassPathEntry;
import proguard.ClassSpecification;
import proguard.ClassSpecificationVisitorFactory;
import proguard.Configuration;
import proguard.ConfigurationParser;
import proguard.DataEntryReaderFactory;
import proguard.DataEntryWriterFactory;
import proguard.GPL;
import proguard.classfile.ClassPool;
import proguard.classfile.attribute.AllAttrInfoVisitor;
import proguard.classfile.editor.ConstantPoolSorter;
import proguard.classfile.instruction.AllInstructionVisitor;
import proguard.classfile.util.ClassFileClassForNameReferenceInitializer;
import proguard.classfile.util.ClassFileHierarchyInitializer;
import proguard.classfile.util.ClassFileReferenceInitializer;
import proguard.classfile.visitor.AllCpInfoVisitor;
import proguard.classfile.visitor.AllMethodVisitor;
import proguard.classfile.visitor.ClassFileHierarchyTraveler;
import proguard.classfile.visitor.ClassFilePrinter;
import proguard.classfile.visitor.ClassFileVisitor;
import proguard.classfile.visitor.ClassPoolFiller;
import proguard.classfile.visitor.ClassPoolVisitor;
import proguard.classfile.visitor.LibraryClassFileFilter;
import proguard.classfile.visitor.MemberInfoVisitor;
import proguard.classfile.visitor.ProgramClassFileFilter;
import proguard.classfile.visitor.ProgramMemberInfoFilter;
import proguard.classfile.visitor.ReferencedClassFileVisitor;
import proguard.classfile.visitor.SimpleClassFilePrinter;
import proguard.io.ClassFileFilter;
import proguard.io.ClassFileReader;
import proguard.io.ClassFileRewriter;
import proguard.io.DataEntryCopier;
import proguard.io.DataEntryReader;
import proguard.io.DataEntryWriter;
import proguard.io.DirectoryPump;
import proguard.obfuscate.Obfuscator;
import proguard.optimize.Optimizer;
import proguard.shrink.Shrinker;
import proguard.util.ClassNameListMatcher;

public class ProGuard {
    public static final String VERSION = "ProGuard, version 3.5";
    private Configuration configuration;
    private ClassPool programClassPool = new ClassPool();
    private ClassPool libraryClassPool = new ClassPool();

    public ProGuard(Configuration configuration) {
        this.configuration = configuration;
    }

    public void execute() throws IOException {
        System.out.println(VERSION);
        GPL.check();
        this.readInput();
        if (this.configuration.defaultPackage != null) {
            this.configuration.allowAccessModification = true;
        }
        if (this.configuration.shrink || this.configuration.optimize || this.configuration.obfuscate) {
            this.initialize();
        }
        if (this.configuration.printSeeds != null) {
            this.printSeeds();
        }
        if (this.configuration.shrink) {
            this.shrink();
        }
        if (this.configuration.optimize) {
            this.optimize();
            if (this.configuration.shrink) {
                this.configuration.printUsage = null;
                this.configuration.whyAreYouKeeping = null;
                this.shrink();
            }
        }
        if (this.configuration.obfuscate) {
            this.obfuscate();
        }
        if (this.configuration.shrink || this.configuration.optimize || this.configuration.obfuscate) {
            this.sortConstantPools();
        }
        if (this.configuration.programJars.hasOutput()) {
            this.writeOutput();
        }
        if (this.configuration.dump != null) {
            this.dump();
        }
    }

    private void readInput() throws IOException {
        if (this.configuration.verbose) {
            System.out.println("Reading jars...");
        }
        if (this.configuration.programJars == null) {
            throw new IOException("The input is empty. You have to specify one or more '-injars' options.");
        }
        this.readInput("Reading program ", this.configuration.programJars, this.createDataEntryClassPoolFiller(false));
        if (this.programClassPool.size() == 0) {
            throw new IOException("The input doesn't contain any class files. Did you specify the proper '-injars' options?");
        }
        if (this.configuration.libraryJars != null) {
            this.readInput("Reading library ", this.configuration.libraryJars, this.createDataEntryClassPoolFiller(true));
        }
    }

    private DataEntryReader createDataEntryClassPoolFiller(boolean bl) {
        ClassPool classPool = bl ? this.libraryClassPool : this.programClassPool;
        return new ClassFileFilter(new ClassFileReader(bl, this.configuration.skipNonPublicLibraryClasses, this.configuration.skipNonPublicLibraryClassMembers, this.configuration.note, new ClassPoolFiller(classPool, this.configuration.note)));
    }

    private void readInput(String string, ClassPath classPath, DataEntryReader dataEntryReader) throws IOException {
        this.readInput(string, classPath, 0, classPath.size(), dataEntryReader);
    }

    private void readInput(String string, ClassPath classPath, int n, int n2, DataEntryReader dataEntryReader) throws IOException {
        for (int i = n; i < n2; ++i) {
            ClassPathEntry classPathEntry = classPath.get(i);
            if (classPathEntry.isOutput()) continue;
            this.readInput(string, classPathEntry, dataEntryReader);
        }
    }

    private void readInput(String string, ClassPathEntry classPathEntry, DataEntryReader dataEntryReader) throws IOException {
        try {
            DataEntryReader dataEntryReader2 = DataEntryReaderFactory.createDataEntryReader(string, classPathEntry, dataEntryReader);
            DirectoryPump directoryPump = new DirectoryPump(classPathEntry.getFile());
            directoryPump.pumpDataEntries(dataEntryReader2);
        }
        catch (IOException iOException) {
            throw new IOException("Can't read [" + classPathEntry + "] (" + iOException.getMessage() + ")");
        }
    }

    private void initialize() throws IOException {
        int n;
        int n2;
        if (this.configuration.verbose) {
            System.out.println("Initializing...");
        }
        int n3 = this.libraryClassPool.size();
        ClassFileHierarchyInitializer classFileHierarchyInitializer = new ClassFileHierarchyInitializer(this.programClassPool, this.libraryClassPool, this.configuration.warn);
        this.programClassPool.classFilesAccept(classFileHierarchyInitializer);
        ClassFileHierarchyInitializer classFileHierarchyInitializer2 = new ClassFileHierarchyInitializer(this.programClassPool, this.libraryClassPool, false);
        this.libraryClassPool.classFilesAccept(classFileHierarchyInitializer2);
        ClassFileClassForNameReferenceInitializer classFileClassForNameReferenceInitializer = new ClassFileClassForNameReferenceInitializer(this.programClassPool, this.libraryClassPool, this.configuration.note, this.createNoteExceptionMatcher(this.configuration.keep));
        this.programClassPool.classFilesAccept(new AllMethodVisitor(new AllAttrInfoVisitor(new AllInstructionVisitor(classFileClassForNameReferenceInitializer))));
        ClassFileReferenceInitializer classFileReferenceInitializer = new ClassFileReferenceInitializer(this.programClassPool, this.libraryClassPool, this.configuration.warn);
        this.programClassPool.classFilesAccept(classFileReferenceInitializer);
        ClassPool classPool = new ClassPool();
        this.programClassPool.classFilesAccept(new AllCpInfoVisitor(new ReferencedClassFileVisitor(new LibraryClassFileFilter(new ClassFileHierarchyTraveler(true, true, true, false, new LibraryClassFileFilter(new ClassPoolFiller(classPool, false)))))));
        this.libraryClassPool = classPool;
        ClassFileReferenceInitializer classFileReferenceInitializer2 = new ClassFileReferenceInitializer(this.programClassPool, this.libraryClassPool, false);
        this.libraryClassPool.classFilesAccept(classFileReferenceInitializer2);
        int n4 = classFileClassForNameReferenceInitializer.getNoteCount();
        if (n4 > 0) {
            System.err.println("Note: there were " + n4 + " class casts of dynamically created class instances.");
            System.err.println("      You might consider explicitly keeping the mentioned classes and/or");
            System.err.println("      their implementations (using '-keep').");
        }
        if ((n2 = classFileHierarchyInitializer.getWarningCount()) > 0) {
            System.err.println("Warning: there were " + n2 + " unresolved references to superclasses or interfaces.");
            System.err.println("         You may need to specify additional library jars (using '-libraryjars'),");
            System.err.println("         or perhaps the '-dontskipnonpubliclibraryclasses' option.");
        }
        if ((n = classFileReferenceInitializer.getWarningCount()) > 0) {
            System.err.println("Warning: there were " + n + " unresolved references to program class members.");
            System.err.println("         Your input class files appear to be inconsistent.");
            System.err.println("         You may need to recompile them and try again.");
        }
        if (!(n2 <= 0 && n <= 0 || this.configuration.ignoreWarnings)) {
            System.err.println("         If you are sure the mentioned classes are not used anyway,");
            System.err.println("         you could try your luck using the '-ignorewarnings' option.");
            throw new IOException("Please correct the above warnings first.");
        }
        if (this.configuration.verbose) {
            System.out.println("Removed unused library classes...");
            System.out.println("  Original number of library classes: " + n3);
            System.out.println("  Final number of library classes:    " + this.libraryClassPool.size());
        }
    }

    private ClassNameListMatcher createNoteExceptionMatcher(List list) {
        if (list != null) {
            ArrayList<String> arrayList = new ArrayList<String>(list.size());
            for (int i = 0; i < list.size(); ++i) {
                String string;
                ClassSpecification classSpecification = (ClassSpecification)list.get(i);
                if (!classSpecification.markClassFiles) continue;
                String string2 = classSpecification.className;
                if (string2 != null) {
                    arrayList.add(string2);
                }
                if ((string = classSpecification.extendsClassName) == null) continue;
                arrayList.add(string);
            }
            if (arrayList.size() > 0) {
                return new ClassNameListMatcher(arrayList);
            }
        }
        return null;
    }

    private void printSeeds() throws IOException {
        if (this.configuration.verbose) {
            System.out.println("Printing kept classes, fields, and methods...");
        }
        if (this.configuration.keep == null) {
            throw new IOException("You have to specify '-keep' options for the shrinking step.");
        }
        PrintStream printStream = this.isFile(this.configuration.printSeeds) ? new PrintStream(new BufferedOutputStream(new FileOutputStream(this.configuration.printSeeds))) : System.out;
        SimpleClassFilePrinter simpleClassFilePrinter = new SimpleClassFilePrinter(false, printStream);
        ClassPoolVisitor classPoolVisitor = ClassSpecificationVisitorFactory.createClassPoolVisitor(this.configuration.keep, (ClassFileVisitor)new ProgramClassFileFilter(simpleClassFilePrinter), (MemberInfoVisitor)new ProgramMemberInfoFilter(simpleClassFilePrinter));
        this.programClassPool.accept(classPoolVisitor);
        this.libraryClassPool.accept(classPoolVisitor);
        if (printStream != System.out) {
            printStream.close();
        }
    }

    private void shrink() throws IOException {
        if (this.configuration.verbose) {
            System.out.println("Shrinking...");
            if (this.configuration.whyAreYouKeeping != null) {
                System.out.println("Explaining why classes and class members are being kept...");
            }
            if (this.configuration.printUsage != null) {
                System.out.println("Printing usage" + (this.isFile(this.configuration.printUsage) ? " to [" + this.configuration.printUsage.getAbsolutePath() + "]" : "..."));
            }
        }
        if (this.configuration.keep == null) {
            throw new IOException("You have to specify '-keep' options for the shrinking step.");
        }
        int n = this.programClassPool.size();
        this.programClassPool = new Shrinker(this.configuration).execute(this.programClassPool, this.libraryClassPool);
        int n2 = this.programClassPool.size();
        if (n2 == 0) {
            throw new IOException("The output jar is empty. Did you specify the proper '-keep' options?");
        }
        if (this.configuration.verbose) {
            System.out.println("Removed unused program classes and class elements...");
            System.out.println("  Original number of program classes: " + n);
            System.out.println("  Final number of program classes:    " + n2);
        }
    }

    private void optimize() throws IOException {
        if (this.configuration.verbose) {
            System.out.println("Optimizing...");
        }
        if (this.configuration.keep == null && this.configuration.keepNames == null && this.configuration.applyMapping == null && this.configuration.printMapping == null) {
            throw new IOException("You have to specify '-keep' options for the optimization step.");
        }
        new Optimizer(this.configuration).execute(this.programClassPool, this.libraryClassPool);
    }

    private void obfuscate() throws IOException {
        if (this.configuration.verbose) {
            System.out.println("Obfuscating...");
            if (this.configuration.applyMapping != null) {
                System.out.println("Applying mapping [" + this.configuration.applyMapping.getAbsolutePath() + "]");
            }
            if (this.configuration.printMapping != null) {
                System.out.println("Printing mapping" + (this.isFile(this.configuration.printMapping) ? " to [" + this.configuration.printMapping.getAbsolutePath() + "]" : "..."));
            }
        }
        new Obfuscator(this.configuration).execute(this.programClassPool, this.libraryClassPool);
    }

    private void sortConstantPools() {
        this.programClassPool.classFilesAccept(new ConstantPoolSorter(1024));
    }

    private void writeOutput() throws IOException {
        ClassPathEntry classPathEntry;
        int n;
        int n2;
        ClassPath classPath;
        ClassPathEntry classPathEntry2;
        if (this.configuration.verbose) {
            System.out.println("Writing jars...");
        }
        if ((classPathEntry2 = (classPath = this.configuration.programJars).get(0)).isOutput()) {
            throw new IOException("The output jar [" + classPathEntry2.getName() + "] must be specified after an input jar, or it will be empty.");
        }
        for (n2 = 0; n2 < classPath.size() - 1; ++n2) {
            ClassPathEntry classPathEntry3 = classPath.get(n2);
            if (!classPathEntry3.isOutput()) continue;
            if (classPathEntry3.getFilter() == null && classPathEntry3.getJarFilter() == null && classPathEntry3.getWarFilter() == null && classPathEntry3.getEarFilter() == null && classPathEntry3.getZipFilter() == null && classPath.get(n2 + 1).isOutput()) {
                throw new IOException("The output jar [" + classPathEntry3.getName() + "] must have a filter, or all subsequent jars will be empty.");
            }
            for (n = 0; n < classPath.size(); ++n) {
                classPathEntry = classPath.get(n);
                if (classPathEntry.isOutput() || !classPathEntry3.getFile().equals(classPathEntry.getFile())) continue;
                throw new IOException("The output jar [" + classPathEntry3.getName() + "] must be different from all input jars.");
            }
        }
        n2 = 0;
        int n3 = 0;
        for (n = 0; n < classPath.size(); ++n) {
            classPathEntry = classPath.get(n);
            if (!classPathEntry.isOutput()) {
                n3 = n;
                continue;
            }
            int n4 = n + 1;
            if (n4 != classPath.size() && classPath.get(n4).isOutput()) continue;
            this.writeOutput(classPath, n2, n3 + 1, n4);
            n2 = n4;
        }
    }

    private void writeOutput(ClassPath classPath, int n, int n2, int n3) throws IOException {
        try {
            DataEntryWriter dataEntryWriter = DataEntryWriterFactory.createDataEntryWriter(classPath, n2, n3);
            ClassFileFilter classFileFilter = new ClassFileFilter(new ClassFileRewriter(this.programClassPool, dataEntryWriter), new DataEntryCopier(dataEntryWriter));
            this.readInput("  Copying resources from program ", classPath, n, n2, classFileFilter);
            dataEntryWriter.close();
        }
        catch (IOException iOException) {
            throw new IOException("Can't write [" + classPath.get(n2).getName() + "] (" + iOException.getMessage() + ")");
        }
    }

    private void dump() throws IOException {
        if (this.configuration.verbose) {
            System.out.println("Printing classes" + (this.isFile(this.configuration.dump) ? " to [" + this.configuration.dump.getAbsolutePath() + "]" : "..."));
        }
        PrintStream printStream = this.isFile(this.configuration.dump) ? new PrintStream(new BufferedOutputStream(new FileOutputStream(this.configuration.dump))) : System.out;
        this.programClassPool.classFilesAccept(new ClassFilePrinter(printStream));
        if (this.isFile(this.configuration.dump)) {
            printStream.close();
        }
    }

    private boolean isFile(File file) {
        return file.getPath().length() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println(VERSION);
            System.out.println("Usage: java proguard.ProGuard [options ...]");
            System.exit(1);
        }
        Configuration configuration = new Configuration();
        try {
            ConfigurationParser configurationParser = new ConfigurationParser(stringArray);
            try {
                configurationParser.parse(configuration);
                new ProGuard(configuration).execute();
            }
            finally {
                configurationParser.close();
            }
        }
        catch (Exception exception) {
            if (configuration.verbose) {
                exception.printStackTrace();
            } else {
                System.err.println("Error: " + exception.getMessage());
            }
            System.exit(1);
        }
        System.exit(0);
    }
}

