/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import proguard.ClassSpecificationVisitorFactory;
import proguard.Configuration;
import proguard.classfile.ClassPool;
import proguard.classfile.editor.ClassFileReferenceFixer;
import proguard.classfile.editor.MemberReferenceFixer;
import proguard.classfile.util.MethodInfoLinker;
import proguard.classfile.visitor.AllMemberInfoVisitor;
import proguard.classfile.visitor.BottomClassFileFilter;
import proguard.classfile.visitor.ClassFileCleaner;
import proguard.classfile.visitor.ClassFileHierarchyTraveler;
import proguard.classfile.visitor.ClassFileVisitor;
import proguard.classfile.visitor.ClassPoolVisitor;
import proguard.classfile.visitor.MemberInfoAccessFilter;
import proguard.classfile.visitor.MemberInfoVisitor;
import proguard.classfile.visitor.MultiClassFileVisitor;
import proguard.classfile.visitor.MultiClassPoolVisitor;
import proguard.classfile.visitor.MultiMemberInfoVisitor;
import proguard.obfuscate.AttributeShrinker;
import proguard.obfuscate.AttributeUsageMarker;
import proguard.obfuscate.ClassFileObfuscator;
import proguard.obfuscate.ClassFileOpener;
import proguard.obfuscate.ClassFileRenamer;
import proguard.obfuscate.DictionaryNameFactory;
import proguard.obfuscate.MapCleaner;
import proguard.obfuscate.MappingKeeper;
import proguard.obfuscate.MappingPrinter;
import proguard.obfuscate.MappingProcessor;
import proguard.obfuscate.MappingReader;
import proguard.obfuscate.MemberInfoNameCleaner;
import proguard.obfuscate.MemberInfoNameCollector;
import proguard.obfuscate.MemberInfoNameConflictFilter;
import proguard.obfuscate.MemberInfoObfuscator;
import proguard.obfuscate.MemberInfoSpecialNameFilter;
import proguard.obfuscate.MultiMappingProcessor;
import proguard.obfuscate.NameAndTypeShrinker;
import proguard.obfuscate.NameAndTypeUsageMarker;
import proguard.obfuscate.NameFactory;
import proguard.obfuscate.NameMarker;
import proguard.obfuscate.SimpleNameFactory;
import proguard.obfuscate.SourceFileRenamer;
import proguard.obfuscate.SpecialNameFactory;
import proguard.obfuscate.Utf8Shrinker;
import proguard.obfuscate.Utf8UsageMarker;

public class Obfuscator {
    private Configuration configuration;

    public Obfuscator(Configuration configuration) {
        this.configuration = configuration;
    }

    public void execute(ClassPool classPool, ClassPool classPool2) throws IOException {
        Object object;
        Object object2;
        if (this.configuration.keep == null && this.configuration.keepNames == null && this.configuration.applyMapping == null && this.configuration.printMapping == null) {
            throw new IOException("You have to specify '-keep' options for the obfuscation step.");
        }
        classPool.classFilesAccept(new ClassFileCleaner());
        classPool2.classFilesAccept(new ClassFileCleaner());
        classPool.classFilesAccept(new BottomClassFileFilter(new MethodInfoLinker()));
        NameMarker nameMarker = new NameMarker();
        MultiClassPoolVisitor multiClassPoolVisitor = new MultiClassPoolVisitor(new ClassPoolVisitor[]{ClassSpecificationVisitorFactory.createClassPoolVisitor(this.configuration.keep, (ClassFileVisitor)nameMarker, (MemberInfoVisitor)nameMarker), ClassSpecificationVisitorFactory.createClassPoolVisitor(this.configuration.keepNames, (ClassFileVisitor)nameMarker, (MemberInfoVisitor)nameMarker)});
        classPool.accept(multiClassPoolVisitor);
        classPool2.accept(multiClassPoolVisitor);
        classPool2.classFilesAccept(nameMarker);
        classPool2.classFilesAccept(new AllMemberInfoVisitor(nameMarker));
        if (this.configuration.applyMapping != null) {
            object2 = new MappingReader(this.configuration.applyMapping);
            object = new MultiMappingProcessor(new MappingProcessor[]{new MappingKeeper(classPool), new MappingKeeper(classPool2)});
            ((MappingReader)object2).pump((MappingProcessor)object);
        }
        object2 = new AttributeUsageMarker();
        if (this.configuration.keepAttributes != null) {
            if (this.configuration.keepAttributes.size() != 0) {
                ((AttributeUsageMarker)object2).setKeepAttributes(this.configuration.keepAttributes);
            } else {
                ((AttributeUsageMarker)object2).setKeepAllAttributes();
            }
        }
        classPool.classFilesAccept((ClassFileVisitor)object2);
        classPool.classFilesAccept(new AttributeShrinker());
        classPool.classFilesAccept(new ClassFileObfuscator(classPool, this.configuration.defaultPackage, this.configuration.useMixedCaseClassNames));
        object = new SimpleNameFactory();
        if (this.configuration.obfuscationDictionary != null) {
            object = new DictionaryNameFactory(this.configuration.obfuscationDictionary, (NameFactory)object);
        }
        HashMap hashMap = new HashMap();
        classPool.classFilesAccept(new BottomClassFileFilter(new MultiClassFileVisitor(new ClassFileVisitor[]{new ClassFileHierarchyTraveler(true, true, true, false, new AllMemberInfoVisitor(new MemberInfoNameCollector(this.configuration.overloadAggressively, hashMap))), new ClassFileHierarchyTraveler(true, true, true, false, new AllMemberInfoVisitor(new MemberInfoAccessFilter(0, 2, new MemberInfoObfuscator(this.configuration.overloadAggressively, (NameFactory)object, hashMap)))), new MapCleaner(hashMap)})));
        classPool.classFilesAccept(new MultiClassFileVisitor(new ClassFileVisitor[]{new AllMemberInfoVisitor(new MemberInfoNameCollector(this.configuration.overloadAggressively, hashMap)), new ClassFileHierarchyTraveler(false, true, true, false, new AllMemberInfoVisitor(new MemberInfoAccessFilter(0, 2, new MemberInfoNameCollector(this.configuration.overloadAggressively, hashMap)))), new AllMemberInfoVisitor(new MemberInfoAccessFilter(2, 0, new MemberInfoObfuscator(this.configuration.overloadAggressively, (NameFactory)object, hashMap))), new MapCleaner(hashMap)}));
        classPool.classFilesAccept(new AllMemberInfoVisitor(new MemberInfoSpecialNameFilter(new MemberInfoNameCollector(this.configuration.overloadAggressively, hashMap))));
        classPool2.classFilesAccept(new AllMemberInfoVisitor(new MemberInfoSpecialNameFilter(new MemberInfoNameCollector(this.configuration.overloadAggressively, hashMap))));
        classPool.classFilesAccept(new AllMemberInfoVisitor(new MemberInfoNameConflictFilter(new MultiMemberInfoVisitor(new MemberInfoVisitor[]{new MemberInfoNameCleaner(), new MemberInfoObfuscator(this.configuration.overloadAggressively, new SpecialNameFactory(new SimpleNameFactory()), hashMap)}))));
        hashMap.clear();
        if (this.configuration.printMapping != null) {
            PrintStream printStream = this.isFile(this.configuration.printMapping) ? new PrintStream(new BufferedOutputStream(new FileOutputStream(this.configuration.printMapping))) : System.out;
            classPool.classFilesAcceptAlphabetically(new MappingPrinter(printStream));
            if (printStream != System.out) {
                printStream.close();
            }
        }
        classPool.classFilesAccept(new ClassFileRenamer());
        classPool2.classFilesAccept(new ClassFileRenamer());
        classPool.classFilesAccept(new ClassFileReferenceFixer(false));
        classPool2.classFilesAccept(new ClassFileReferenceFixer(false));
        classPool.classFilesAccept(new MemberReferenceFixer(1024));
        if (this.configuration.defaultPackage != null) {
            classPool.classFilesAccept(new ClassFileOpener());
        }
        if (this.configuration.newSourceFileAttribute != null) {
            classPool.classFilesAccept(new SourceFileRenamer(this.configuration.newSourceFileAttribute));
        }
        classPool.classFilesAccept(new NameAndTypeUsageMarker());
        classPool.classFilesAccept(new NameAndTypeShrinker(1024));
        classPool.classFilesAccept(new Utf8UsageMarker());
        classPool.classFilesAccept(new Utf8Shrinker(1024));
    }

    private boolean isFile(File file) {
        return file.getPath().length() > 0;
    }
}

