/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import proguard.classfile.ClassFile;
import proguard.classfile.LibraryClassFile;
import proguard.classfile.LibraryFieldInfo;
import proguard.classfile.LibraryMethodInfo;
import proguard.classfile.ProgramClassFile;
import proguard.classfile.ProgramFieldInfo;
import proguard.classfile.ProgramMethodInfo;
import proguard.classfile.visitor.ClassFileVisitor;
import proguard.classfile.visitor.MemberInfoVisitor;

public class ClassFileMemberInfoVisitor
implements MemberInfoVisitor {
    private ClassFileVisitor classFileVisitor;
    private ClassFile lastVisitedClassFile;

    public ClassFileMemberInfoVisitor(ClassFileVisitor classFileVisitor) {
        this.classFileVisitor = classFileVisitor;
    }

    public void visitProgramFieldInfo(ProgramClassFile programClassFile, ProgramFieldInfo programFieldInfo) {
        if (!programClassFile.equals(this.lastVisitedClassFile)) {
            this.classFileVisitor.visitProgramClassFile(programClassFile);
            this.lastVisitedClassFile = programClassFile;
        }
    }

    public void visitProgramMethodInfo(ProgramClassFile programClassFile, ProgramMethodInfo programMethodInfo) {
        if (!programClassFile.equals(this.lastVisitedClassFile)) {
            this.classFileVisitor.visitProgramClassFile(programClassFile);
            this.lastVisitedClassFile = programClassFile;
        }
    }

    public void visitLibraryFieldInfo(LibraryClassFile libraryClassFile, LibraryFieldInfo libraryFieldInfo) {
        if (!libraryClassFile.equals(this.lastVisitedClassFile)) {
            this.classFileVisitor.visitLibraryClassFile(libraryClassFile);
            this.lastVisitedClassFile = libraryClassFile;
        }
    }

    public void visitLibraryMethodInfo(LibraryClassFile libraryClassFile, LibraryMethodInfo libraryMethodInfo) {
        if (!libraryClassFile.equals(this.lastVisitedClassFile)) {
            this.classFileVisitor.visitLibraryClassFile(libraryClassFile);
            this.lastVisitedClassFile = libraryClassFile;
        }
    }
}

